import { DataTypes } from 'sequelize';
import { sequelize } from '../config/database.js';

export const Trash = sequelize.define('trash', {
  id: {
    type: DataTypes.UUID,
    defaultValue: DataTypes.UUIDV4,
    primaryKey: true
  },
  file_id: {
    type: DataTypes.UUID,
    allowNull: false
  },
  owner_id: {
    type: DataTypes.UUID,
    allowNull: false
  },
  deleted_at: {
    type: DataTypes.DATE,
    allowNull: false,
    defaultValue: DataTypes.NOW
  }
});
