// Script to print file owner_id and all user IDs in the database
// Usage: node checkFileOwner.js <fileId>

import { sequelize } from './config/database.js';
import { File } from './models/File.js';
import { User } from './models/User.js';

const fileId = process.argv[2];
if (!fileId) {
  console.error('Usage: node checkFileOwner.js <fileId>');
  process.exit(1);
}

async function checkFileOwner(id) {
  await sequelize.authenticate();
  const file = await File.findOne({ where: { id } });
  if (!file) {
    console.log(`File with id ${id} not found.`);
    process.exit(0);
  }
  console.log(`File: ${file.name} (id: ${file.id})`);
  console.log(`owner_id: ${file.owner_id}`);

  const owner = await User.findOne({ where: { id: file.owner_id } });
  if (owner) {
    console.log(`Owner email: ${owner.email}, name: ${owner.name}`);
  } else {
    console.log('Owner not found in users table.');
  }

  const users = await User.findAll();
  console.log('\nAll users in database:');
  users.forEach(u => {
    console.log(`- id: ${u.id}, email: ${u.email}, name: ${u.name}`);
  });
}

checkFileOwner(fileId).then(() => sequelize.close());
