// scripts/list_user_files.js
// Usage: node scripts/list_user_files.js <user_id>
import { File, User } from '../server/models/index.js';

const userId = process.argv[2];
if (!userId) {
  console.error('Usage: node scripts/list_user_files.js <user_id>');
  process.exit(1);
}

(async () => {
  const user = await User.findByPk(userId);
  if (!user) {
    console.error('User not found');
    process.exit(1);
  }
  const files = await File.findAll({
    where: { owner_id: userId },
    attributes: ['id', 'name', 'size', 'is_deleted', 'type', 'mime_type', 'created_at', 'updated_at'],
    order: [['size', 'DESC']]
  });
  let total = 0;
  for (const file of files) {
    total += file.size || 0;
    console.log(`${file.id}\t${file.name}\t${file.size}\t${file.is_deleted ? 'DELETED' : ''}\t${file.type}\t${file.mime_type}`);
  }
  console.log(`Total (raw sum): ${total} bytes`);
})();
