'use strict';

/** @type {import('sequelize-cli').Migration} */
module.exports = {
  async up (queryInterface, Sequelize) {
    // Drop the existing foreign key constraint
    await queryInterface.removeConstraint('files', 'files_parent_id_fkey');
    // Add the new constraint with ON DELETE CASCADE
    await queryInterface.addConstraint('files', {
      fields: ['parent_id'],
      type: 'foreign key',
      name: 'files_parent_id_fkey',
      references: {
        table: 'files',
        field: 'id',
      },
      onDelete: 'CASCADE',
      onUpdate: 'CASCADE',
    });
  },

  async down (queryInterface, Sequelize) {
    // Remove the CASCADE constraint
    await queryInterface.removeConstraint('files', 'files_parent_id_fkey');
    // Re-add the original constraint (no cascade)
    await queryInterface.addConstraint('files', {
      fields: ['parent_id'],
      type: 'foreign key',
      name: 'files_parent_id_fkey',
      references: {
        table: 'files',
        field: 'id',
      },
      onDelete: 'NO ACTION',
      onUpdate: 'CASCADE',
    });
  }
};
