// Script to check if a file is in the trash and marked as deleted
// Usage: node checkFileTrashState.js <fileId>

import { sequelize } from './config/database.js';
import { File } from './models/File.js';
import { Trash } from './models/Trash.js';

const fileId = process.argv[2];
if (!fileId) {
  console.error('Usage: node checkFileTrashState.js <fileId>');
  process.exit(1);
}

async function checkFileState(id) {
  await sequelize.authenticate();
  const file = await File.findOne({ where: { id } });
  const trash = await Trash.findOne({ where: { file_id: id } });

  if (!file) {
    console.log(`File with id ${id} not found.`);
    process.exit(0);
  }

  console.log(`File: ${file.name} (id: ${file.id})`);
  console.log(`is_deleted: ${file.is_deleted}`);
  console.log(`In trash table: ${!!trash}`);
  if (trash) {
    console.log(`Trash entry deleted_at: ${trash.deleted_at}`);
  }
}

checkFileState(fileId).then(() => sequelize.close());
