// Debug endpoint to list all files for the current user (for troubleshooting storage issues)
import express from 'express';
import { File } from '../models/index.js';
import { authenticate } from '../middleware/auth.js';

const router = express.Router();

router.get('/debug/files', authenticate, async (req, res, next) => {
  try {
    const files = await File.findAll({ where: { owner_id: req.user.id } });
    res.json({ files });
  } catch (error) {
    next(error);
  }
});

export default router;
