import { DataTypes } from 'sequelize';
import { sequelize } from '../config/database.js';

export const FileShare = sequelize.define('file_shares', {
  id: {
    type: DataTypes.UUID,
    defaultValue: DataTypes.UUIDV4,
    primaryKey: true
  },
  file_id: {
    type: DataTypes.UUID,
    allowNull: false,
    references: {
      model: 'files',
      key: 'id'
    }
  },
  user_id: {
    type: DataTypes.UUID,
    allowNull: false,
    references: {
      model: 'users',
      key: 'id'
    }
  },
  permissions: {
    type: DataTypes.ARRAY(DataTypes.STRING), // e.g. ['read', 'write']
    allowNull: false,
    defaultValue: ['read']
  }
}, {
  indexes: [
    { fields: ['file_id'] },
    { fields: ['user_id'] }
  ],
  uniqueKeys: {
    unique_share: {
      fields: ['file_id', 'user_id']
    }
  }
});
